package osc;

import java.util.Vector;
import java.util.Enumeration;
import java.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

// for program description and credits, see the sjmComm_readme.txt


public class OscMessage {
    private String name;
    private Vector types;
    private Vector arguments;
	private boolean tmpFlag = false;
    
    /*
    Constructor for the OscMessage.
    */
    
    public OscMessage(String name) {
	this.name 	= name;
	types 		= new Vector();
	arguments 	= new Vector();
    }

    /*
    Adds a type/argument pair to the list of arguments
    */
    
    public void addArg(Character type, Object argument) {
	types.addElement(type);
	arguments.addElement(argument);
    }
	
	 public void addBracket(Character type) {
	types.addElement(type);
    }
    
    // Directly sets the type and arg Vectors
    public void setTypesAndArgs(Vector types, Vector args) {
	this.types 		= types;
	this.arguments 	= args;
    }
	
	
    // Returns an XML representation of the message
    public String getName() {
	if (types == null)
	    return "Osc Message getXml > ERROR Types not set";
	else
		return name;
	}
	
	public Vector getTypes() {
		return types;
	}
	
	public Vector getArgs() {
		return arguments;
	}
	
    
    /*
    Returns a byte array representation of this message.
    */
    public byte[] getByteArray() throws IOException {
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	DataOutputStream stream = new DataOutputStream(baos);
	
	// address (name)
	stream.writeBytes( name );
	alignStream( baos );

	// type tags
	stream.writeByte( ',' );  // comma indicates type tags
	
	Enumeration t = types.elements();
	while ( t.hasMoreElements() ) {
	    char type = ( (Character)t.nextElement() ).charValue();
	    stream.writeByte( type );
	}
	alignStream( baos );

	// values
	t = types.elements();
	Enumeration a = arguments.elements();
	while ( t.hasMoreElements() ) {
	    char type = ( (Character)t.nextElement() ).charValue();
	    switch(type) {
	    case 'i':
		stream.writeInt( ((Integer)a.nextElement()).intValue() );
		break;
	    case 'f':
		stream.writeFloat( ((Float)a.nextElement()).floatValue() );
		break;
	    case 'h':
		stream.writeLong( ((Long)a.nextElement()).longValue() );
		break;
	    case 'd':
		stream.writeDouble( ((Double)a.nextElement()).doubleValue() );
		break;
	    case 's':
		stream.writeBytes( checkString((String)a.nextElement()) );
		break;
	    }    
	}
	return baos.toByteArray();
    }
	
	/*
		additional function for writing strings correctly in the Bytes.
		a string has to be filled with \0 at the end, so that the string
		Bytes are a multiple of 4.
	*/
	public String checkString(String theString) {
		int tmpLength = theString.length();
		for (int i=0; i<4-(tmpLength%4); i++){
			theString+="\0";
		}
		return theString;
	}
	
	
	public static void printBytes(byte[] byteArray) {
		for (int i=0; i<byteArray.length; i++) {
		    System.out.print(byteArray[i] + " (" + (char)byteArray[i] + ")  ");
		    if ((i+1)%4 == 0)
			System.out.print("\n");
		}
    }
	
    /*
    Make the stream end on a 4-byte boundary by padding it with
    null characters.
    */
    private void alignStream(ByteArrayOutputStream stream) throws IOException {
        int pad = 4 - ( stream.size() % 4 );
        for (int i = 0; i < pad; i++)
            stream.write(0);
    }
}
