import osc.OscSocket;
import osc.OscMessage;
import osc.OscPacket;
import osc.Bytes;

import java.util.Vector;
import java.util.Enumeration;
import java.util.List;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.net.InetAddress;


public class OscReceiver extends Thread {
    private DatagramSocket 		oscSocket;       				// incoming UDP socket
    private int 				port;                       	// incoming UDP port
    private boolean 			firstNameFlag 	= true;
	private Thread				thrThis 		= null;
	private BApplet			 	parent;	
	
	boolean netFlag				= false;
	MessageINcontainer[] messageINcontainer;
	
    public OscReceiver(BApplet parent, int port) {
		this.parent = parent;
		this.port = port;
		System.out.println("osc receiver created ...");
    }

	public void start() {
        if(thrThis == null) {
            thrThis = new Thread(this);
            thrThis.start();
        }
    }

   
	
	 /**
     This method is based on dumpOSC::ParseOSCPacket.  It verifies
     that the packet is well-formed and puts the data into an
     OscPacket object, or else prints useful error messages about
     what went wrong.
     */
     
    public boolean parseOscPacket(byte[] datagram, int n, OscPacket packet) {
		int size, i;
		boolean returnFlag = true;

	if ( (n % 4) != 0 ) {
		System.out.println(" parseOscPacket() SynthControl packet size (" + n +") not a multiple of 4 bytes, dropped it.");
		returnFlag = false;
	    return false;
	}

	String dataString = new String(datagram);
	
	if ( ( n >= 8 ) && dataString.startsWith( "#bundle" ) ) {
	    /* This is a bundle message. */
	    if ( n < 16 ) {
		System.out.println(" parseOscPacket() Bundle message too small (" + n +
			      " bytes) for time tag, dropped it.");
		returnFlag = false;
		return false;
	    }

	    /* Get the time tag */
	    Long time = new Long( Bytes.toLong( Bytes.copy(datagram, 8, 8) ) );
	    packet.setTime(time.longValue());
	    i = 16; /* Skip "#bundle\0" and time tags */
	    while( i<n ) {
			size = ( Bytes.toInt( Bytes.copy(datagram, i, i+4 ) ) );
			if ((size % 4) != 0) {
				System.out.println(" parseOscPacket() Bad size count" + size + "in bundle (not a multiple of 4)");
		    	returnFlag = false;
		    	return false;
			}
			if ( (size + i + 4) > n ) {
		    	System.out.println(" parseOscPacket() Bad size count" + size + "in bundle" +"(only" + (n-i-4) + "bytes left in entire bundle)");
		    	returnFlag = false;
		    	return false;
			}
		
			/* Recursively handle element of bundle */
			byte[] remaining =  Bytes.copy(datagram, i+4);
			
			if (parseOscPacket(remaining, size, packet)) { 
				returnFlag=true;
			} else {
				returnFlag=false;
			}
			i += (4 + size);
			
	    }
	} else {
	    /* This is not a bundle message */	    
	    Vector nameAndData = getStringAndData(datagram, n);
		if (nameAndData.size()>1) {
			String name = (String)nameAndData.firstElement();
			
				if (firstNameFlag==true) {
					packet.msgName 	= name;
					firstNameFlag 	= false;
				}

		    	OscMessage message = new OscMessage(name);
				byte[] data = (byte[]) nameAndData.lastElement();
				Vector[] typesAndArgs = getTypesAndArgs(data);
				message.setTypesAndArgs(typesAndArgs[0], typesAndArgs[1]);
				packet.addMessage(message);
		    	
		} else {
			returnFlag=false;
		}
		
	}
	return returnFlag;
    }
	
	
    
    /*
    Takes a byte array starting with a string padded with null
    characters so that the length of the entire block is a multiple
    of 4, and seperates it into a String and a byte array of the
    remaining data.  These are then returned in a Vector.
    */	
    public Vector getStringAndData(byte[] block, int stringLength) {
	Vector v = new Vector();
	int i;
	
	if ( stringLength %4 != 0) {
	    System.out.println(" getStringAndData() printNameAndArgs: bad boundary");
	    return v;
	}

	for (i = 0; block[i] != '\0'; i++) {
	    if (i >= stringLength) {
		System.out.println(" getStringAndData() printNameAndArgs: Unreasonably long string");
		return v;
	    }
	}
	// v.firstElement() is the String
	v.addElement( new String(Bytes.copy(block, 0, i)) );

	i++;
	for (; (i % 4) != 0; i++) {
	    if (i >= stringLength) {
		System.out.println(" getStringAndData() printNameAndArgs: Unreasonably long string");
		return v;
	    }
	    if (block[i] != '\0') {
		System.out.println(" getStringAndData() printNameAndArgs: Incorrectly padded string.");
		return v;
	    }
	}
	// v.elementAt(1) is the position in the orginal byte[] where the data starts
	v.addElement( new Integer(i) );
	// v.lastElement() is the byte[] of data
	v.addElement( Bytes.copy( block, i ) );
	return v;
    }

    /*
    Returns an array of Vectors containing types and arguments.
    */
    public Vector[] getTypesAndArgs( byte[] block ) {
	// TBD : throw exceptions or something when there are no type tags
	int n = block.length;
	Vector[] va = new Vector[2];
	if (n != 0) {
	    if (block[0] == ',') {
		if (block[1] != ',') {
		    /* This message begins with a type-tag string */
		    va = getTypeTaggedArgs( block );
		} else {
		    /* Double comma means an escaped real comma, not a
		     * type string */
		    va = getHeuristicallyTypeGuessedArgs( block );
		}
	    } else {
		va = getHeuristicallyTypeGuessedArgs( block );
	    }
	}
	return va;
    }

    /*
    Returns Vectors containing the types and arguments from a
    type-tagged byte array
    */
    public Vector[] getTypeTaggedArgs( byte[] block ) {
		Vector typeVector = new Vector();
		Vector argVector = new Vector();
		
		int p = 0;

		/* seperate the block into the types byte array and the
		 * argument byte array
		*/
		Vector typesAndArgs = getStringAndData(block, block.length);
		if (typesAndArgs.size()>1) {
			byte[] args = (byte[]) typesAndArgs.lastElement();
		
			for (int thisType=1; block[thisType] != 0; thisType++) {
	    		switch (block[thisType]) {

		    	case '[' :
					typeVector.addElement(new Character('['));
					break;		
					
		    	case ']' :
					typeVector.addElement(new Character(']'));
					break;

	    		case 'i': case 'r': case 'm': case 'c':
					typeVector.addElement(new Character('i'));
					argVector.addElement( new Integer( Bytes.toInt( Bytes.copy(args, p, p+4) )) );
					p += 4;
					break;
		
	 	   		case 'f':
					typeVector.addElement(new Character('f'));
					argVector.addElement( new Float( Bytes.toFloat( Bytes.copy(args, p, p+4) )) );
					p += 4;
					break;
		
				case 'h': case 't':
					typeVector.addElement(new Character('h'));
					argVector.addElement( new Long( Bytes.toLong( Bytes.copy(args, p, p+8) )) );
					p += 8;
					break;
		
				case 'd':
					typeVector.addElement(new Character('d'));
					argVector.addElement( new Double( Bytes.toDouble( Bytes.copy(args, p, p+8) )) );
					p += 8;
					break;
		
				case 's': case 'S':
					typeVector.addElement(new Character('s'));
					byte[] remaining = Bytes.copy(args, p);
					Vector v = getStringAndData( remaining, remaining.length );
					if (v.size()>1) {
						argVector.addElement( (String)v.firstElement() );
						p += ((Integer)v.elementAt(1)).intValue();
					}
					break;
			
				case 'T':
					typeVector.addElement(new Character('T'));
					argVector.addElement(new Boolean(true));
					break;
				case 'F':
					typeVector.addElement(new Character('F'));
					argVector.addElement(new Boolean(true));
					break;
	    		case 'N':
					typeVector.addElement(new Character('N'));
					argVector.addElement(null);
					break;
	    		case 'I':
					typeVector.addElement(new Character('I'));
					break;

				default:
					System.out.println( " getTypeTaggedArgs() [Unrecognized type tag " + block[thisType] + "]" );
				}
			}
		}

		Vector[] returnValue = new Vector[2];
		returnValue[0] = typeVector;
		returnValue[1] = argVector;
		return returnValue;
    }
	

    /*
    Returns the arguments from a non-type-tagged byte array
    */
    public Vector[] getHeuristicallyTypeGuessedArgs( byte[] block ) {
		// TBD : handle packets without type tags
		System.out.println(" getHeuristicallyTypeGuessedArgs() Bad OSC packet: No type tags");
		return new Vector[2];
    }


    
    /*
    Stops the UDP server.
    */
    public void killServer() {
		// --- close the socket
		oscSocket.close();
		thrThis = null;
		System.out.println(" killOSC() ... stopped");
    }
    
    
     /*
    Thread run method.  Monitors incoming messages.
    */	
    public void run() {
    while(Thread.currentThread() == thrThis) {
	try{
	    // --- create a new UDP OSC socket
	    oscSocket = new DatagramSocket(port);
	    System.out.println("osc receiver started on port: " + port);
	    while(true) {
	    	DatagramSocket clientSocket = new DatagramSocket();
			byte[] datagram  			= new byte[2048];
			DatagramPacket packet 		= new DatagramPacket(datagram, datagram.length);
			oscSocket.receive(packet);					// block until a datagram is received
		
			OscPacket oscp 		= new OscPacket();			// parse the packet
			oscp.address 		= packet.getAddress();
			oscp.port 			= packet.getPort();
			
			firstNameFlag = true;
			
			if (parseOscPacket(datagram, packet.getLength(), oscp)==true) {
				// a packet was received.
				Vector tmpVector = oscp.extractPacket();
				int tmpSize = tmpVector.size();
				if (tmpSize>0) {
					this.messageINcontainer = new MessageINcontainer[tmpSize];
					for(int i=0;i<tmpSize;i++) {
						Vector msgVector = (Vector)tmpVector.elementAt(i);
						this.messageINcontainer[i] = new MessageIN();
						this.messageINcontainer[i].addAddrPattern((String)msgVector.elementAt(0));
						this.messageINcontainer[i].setOscStructure((Vector)msgVector.elementAt(1));
						this.messageINcontainer[i].setOscData((Vector)msgVector.elementAt(2));
						this.messageINcontainer[i].setTypeString();
						
						this.netFlag = true;
					}
				}
			}
			//System.out.println("** raw packet **");
			//OscPacket.printBytes( datagram );
			//System.out.println("** constructed packet **");
			//OscPacket.printBytes( oscp.getByteArray() );
	    }
	} catch(IOException ioe) {
		System.out.println("Server error...Stopping OSC receiver");
	} finally {
		killServer();
        }
    }
    }
	
	boolean checkNet() {
		if (this.netFlag) {
			this.netFlag = false;
			return true;
		} else {
			return false;
		}
	}
}
	abstract class MessageINcontainer {

		abstract void addAddrPattern(String s);
		abstract void setOscStructure(Vector v);
		abstract void setOscData(Vector v);
		abstract void setTypeString();
		abstract String getAddrPattern();
		abstract boolean checkTypes(String s);
		abstract boolean checkAddrPattern(String s);
		abstract Vector getOscStructure();
		abstract Vector getOscData();
		abstract String getStructureAsString();
	}
	
	class MessageIN extends MessageINcontainer {
	
		String addrPattern;
		String typeString = "";
		Vector structure;
		Vector data;
		
		MessageIN() {}
		
		void addAddrPattern(String s) {
			addrPattern = s;
		}
		

		void setOscStructure(Vector v) {
			structure = v;
		}
		
		void setOscData(Vector v) {
			data = v;
		}
		
		void setTypeString() {
			for(int i=0;i<this.structure.size();i++) {
				typeString += this.structure.elementAt(i);
			}
		}
		
		boolean checkTypes(String s) {
			return (s.equals(this.typeString));
		}
		
		boolean checkAddrPattern(String s) {
			return (s.equals(addrPattern));
		}
		
		String getAddrPattern() {
			return addrPattern;
		}
		
		
		Vector getOscStructure() {
			return structure;
		}
		
		
		Vector getOscData() {
			return data;
		}
		
		String getStructureAsString() {
			return structure.toString();
		}
		
	}
	